/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen.trees;

import java.util.Random;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.api.util.ITreeGenerator;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.wood.BlockLeavesTFC;
import net.dries007.tfc.objects.blocks.wood.BlockLogTFC;
import net.dries007.tfc.objects.blocks.wood.BlockSaplingTFC;
import net.dries007.tfc.world.classic.StructureHelper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class TreeGenSequoia
implements ITreeGenerator {
    private static final BlockPos[] OFFSETS = new BlockPos[]{new BlockPos(0, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, -1), new BlockPos(-1, 0, -1)};
    private final PlacementSettings settings = StructureHelper.getDefaultSettings();
    private IBlockState trunk;

    @Override
    public void generateTree(TemplateManager manager, World world, BlockPos pos, Tree tree, Random rand, boolean isWorldGen) {
        int baseVariant = 1 + rand.nextInt(3);
        int topVariant = 1 + rand.nextInt(3);
        int layers = 4 + rand.nextInt(3);
        int height = 3 + rand.nextInt(4);
        this.trunk = BlockLogTFC.get(tree).func_176223_P().func_177226_a((IProperty)BlockLogTFC.PLACED, (Comparable)Boolean.valueOf(false));
        for (int i = -2; i < height; ++i) {
            this.placeTrunk(world, pos.func_177982_a(0, i, 0));
        }
        int k = height;
        for (int j = 0; j < layers; ++j) {
            if (j == layers - 1 || j == layers - 2 && rand.nextBoolean()) {
                k += this.placeLayer(manager, world, pos.func_177981_b(k), tree.getRegistryName() + "/mid" + baseVariant);
                continue;
            }
            k += this.placeLayer(manager, world, pos.func_177981_b(k), tree.getRegistryName() + "/base" + baseVariant);
        }
        this.placeLayer(manager, world, pos.func_177981_b(k), tree.getRegistryName() + "/top" + topVariant);
    }

    @Override
    public boolean canGenerateTree(World world, BlockPos pos, Tree treeType) {
        for (BlockPos p1 : OFFSETS) {
            if (BlocksTFC.isSoil(world.func_180495_p(pos.func_177971_a((Vec3i)p1).func_177977_b())) || world.func_180495_p(pos.func_177971_a((Vec3i)p1)).func_185904_a().func_76222_j() && (BlocksTFC.isSoil(world.func_180495_p(pos.func_177971_a((Vec3i)p1).func_177979_c(1))) || BlocksTFC.isSoil(world.func_180495_p(pos.func_177971_a((Vec3i)p1).func_177979_c(2))) && world.func_180495_p(pos.func_177971_a((Vec3i)p1.func_177979_c(1))).func_185904_a().func_76222_j())) continue;
            return false;
        }
        return ITreeGenerator.super.canGenerateTree(world, pos, treeType);
    }

    private int placeLayer(TemplateManager manager, World world, BlockPos pos, String name) {
        ResourceLocation base = new ResourceLocation(name);
        Template structureBase = manager.func_189942_b(world.func_73046_m(), base);
        if (structureBase == null) {
            TerraFirmaCraft.getLog().warn("Unable to find a template for " + base.toString());
            return -1;
        }
        BlockPos size = structureBase.func_186259_a();
        pos = pos.func_177982_a(-size.func_177958_n() / 2, 0, -size.func_177952_p() / 2);
        StructureHelper.addStructureToWorld(world, pos, structureBase, this.settings);
        return size.func_177956_o();
    }

    private void placeTrunk(World world, BlockPos pos) {
        for (BlockPos p1 : OFFSETS) {
            this.checkAndPlace(world, pos.func_177971_a((Vec3i)p1));
        }
    }

    private void checkAndPlace(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76222_j() || world.func_180495_p(pos).func_177230_c() instanceof BlockSaplingTFC || world.func_180495_p(pos).func_177230_c() instanceof BlockLeavesTFC) {
            world.func_175656_a(pos, this.trunk);
        }
    }
}

